/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.retrier.RetryConfiguration;

public class ClientConfiguration {
    private static final int CONNECTION_TIMEOUT_MILLIS = 10000;
    private static final int READ_TIMEOUT_MILLIS = 60000;
    private static final int MAX_ASYNC_THREADS = 50;
    private final int connectionTimeoutMillis;
    private final int readTimeoutMillis;
    private final int maxAsyncThreads;
    private final RetryConfiguration retryConfiguration;
    private final CircuitBreakerConfiguration circuitBreakerConfiguration;
    private final OciCircuitBreaker circuitBreaker;

    private ClientConfiguration(Integer connectionTimeoutMillis, Integer readTimeoutMillis, Integer maxAsyncThreads, Boolean disableDataBufferingOnUpload, RetryConfiguration retryConfiguration, CircuitBreakerConfiguration circuitBreakerConfiguration, OciCircuitBreaker circuitBreaker) {
        this.connectionTimeoutMillis = ClientConfiguration.getOrDefault(connectionTimeoutMillis, 10000);
        this.readTimeoutMillis = ClientConfiguration.getOrDefault(readTimeoutMillis, 60000);
        this.maxAsyncThreads = ClientConfiguration.getOrDefault(maxAsyncThreads, 50);
        this.retryConfiguration = retryConfiguration;
        this.circuitBreakerConfiguration = circuitBreakerConfiguration;
        this.circuitBreaker = circuitBreaker;
    }

    private static <T> T getOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static ClientConfigurationBuilder builder() {
        return new ClientConfigurationBuilder();
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public int getMaxAsyncThreads() {
        return this.maxAsyncThreads;
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public CircuitBreakerConfiguration getCircuitBreakerConfiguration() {
        return this.circuitBreakerConfiguration;
    }

    public OciCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public String toString() {
        return "ClientConfiguration(connectionTimeoutMillis=" + this.getConnectionTimeoutMillis() + ", readTimeoutMillis=" + this.getReadTimeoutMillis() + ", maxAsyncThreads=" + this.getMaxAsyncThreads() + ", retryConfiguration=" + this.getRetryConfiguration() + ", circuitBreakerConfiguration=" + this.getCircuitBreakerConfiguration() + ", circuitBreaker=" + this.getCircuitBreaker() + ")";
    }

    public static class ClientConfigurationBuilder {
        private Integer connectionTimeoutMillis;
        private Integer readTimeoutMillis;
        private Integer maxAsyncThreads;
        private Boolean disableDataBufferingOnUpload;
        private RetryConfiguration retryConfiguration;
        private CircuitBreakerConfiguration circuitBreakerConfiguration;
        private OciCircuitBreaker circuitBreaker;

        ClientConfigurationBuilder() {
        }

        public ClientConfigurationBuilder connectionTimeoutMillis(Integer connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public ClientConfigurationBuilder readTimeoutMillis(Integer readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public ClientConfigurationBuilder maxAsyncThreads(Integer maxAsyncThreads) {
            this.maxAsyncThreads = maxAsyncThreads;
            return this;
        }

        public ClientConfigurationBuilder disableDataBufferingOnUpload(Boolean disableDataBufferingOnUpload) {
            this.disableDataBufferingOnUpload = disableDataBufferingOnUpload;
            return this;
        }

        public ClientConfigurationBuilder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public ClientConfigurationBuilder circuitBreakerConfiguration(CircuitBreakerConfiguration circuitBreakerConfiguration) {
            this.circuitBreakerConfiguration = circuitBreakerConfiguration;
            return this;
        }

        public ClientConfigurationBuilder circuitBreaker(OciCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public ClientConfiguration build() {
            return new ClientConfiguration(this.connectionTimeoutMillis, this.readTimeoutMillis, this.maxAsyncThreads, this.disableDataBufferingOnUpload, this.retryConfiguration, this.circuitBreakerConfiguration, this.circuitBreaker);
        }

        public String toString() {
            return "ClientConfiguration.ClientConfigurationBuilder(connectionTimeoutMillis=" + this.connectionTimeoutMillis + ", readTimeoutMillis=" + this.readTimeoutMillis + ", maxAsyncThreads=" + this.maxAsyncThreads + ", disableDataBufferingOnUpload=" + this.disableDataBufferingOnUpload + ", retryConfiguration=" + this.retryConfiguration + ", circuitBreakerConfiguration=" + this.circuitBreakerConfiguration + ", circuitBreaker=" + this.circuitBreaker + ")";
        }
    }
}

