/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.sequences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.helper.ExecutionMode;
import org.netbeans.installer.wizard.components.WizardSequence;
import org.netbeans.installer.wizard.components.actions.DownloadConfigurationLogicAction;
import org.netbeans.installer.wizard.components.actions.DownloadInstallationDataAction;
import org.netbeans.installer.wizard.components.actions.InstallAction;
import org.netbeans.installer.wizard.components.actions.UninstallAction;
import org.netbeans.installer.wizard.components.panels.LicensesPanel;
import org.netbeans.installer.wizard.components.panels.PostInstallSummaryPanel;
import org.netbeans.installer.wizard.components.panels.PreInstallSummaryPanel;
import org.netbeans.installer.wizard.components.sequences.ProductWizardSequence;

public class MainSequence
extends WizardSequence {
    private DownloadConfigurationLogicAction downloadConfigurationLogicAction = new DownloadConfigurationLogicAction();
    private LicensesPanel licensesPanel = new LicensesPanel();
    private PreInstallSummaryPanel preInstallSummaryPanel = new PreInstallSummaryPanel();
    private UninstallAction uninstallAction = new UninstallAction();
    private DownloadInstallationDataAction downloadInstallationDataAction = new DownloadInstallationDataAction();
    private InstallAction installAction = new InstallAction();
    private PostInstallSummaryPanel postInstallSummaryPanel = new PostInstallSummaryPanel();
    private Map<Product, ProductWizardSequence> productSequences = new HashMap<Product, ProductWizardSequence>();

    @Override
    public void executeForward() {
        Registry registry = Registry.getInstance();
        List<Product> toInstall = registry.getProductsToInstall();
        List<Product> toUninstall = registry.getProductsToUninstall();
        this.getChildren().clear();
        if (toInstall.size() > 0) {
            this.addChild(this.downloadConfigurationLogicAction);
            this.addChild(this.licensesPanel);
            for (Product product : toInstall) {
                if (!this.productSequences.containsKey(product)) {
                    this.productSequences.put(product, new ProductWizardSequence(product));
                }
                this.addChild(this.productSequences.get(product));
            }
        }
        this.addChild(this.preInstallSummaryPanel);
        if (toUninstall.size() > 0) {
            this.addChild(this.uninstallAction);
        }
        if (toInstall.size() > 0) {
            this.addChild(this.downloadInstallationDataAction);
            this.addChild(this.installAction);
        }
        this.addChild(this.postInstallSummaryPanel);
        super.executeForward();
    }

    @Override
    public boolean canExecuteForward() {
        return ExecutionMode.NORMAL == ExecutionMode.getCurrentExecutionMode();
    }
}

