/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.anchor;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.Widget;

public final class RectangularAnchor
extends Anchor {
    private boolean includeBorders;

    public RectangularAnchor(Widget widget, boolean bl) {
        super(widget);
        this.includeBorders = bl;
    }

    @Override
    public boolean allowsArbitraryConnectionPlacement() {
        return false;
    }

    @Override
    public List<Point> compute(List<Point> list) {
        ArrayList<Point> arrayList = new ArrayList<Point>(list);
        Point point = this.getRelatedSceneLocation();
        int n = 1;
        int n2 = 0;
        Point point2 = arrayList.get(n2);
        if (!point2.equals(point)) {
            n2 = arrayList.size() - 1;
            point2 = arrayList.get(n2);
            n = -1;
        }
        Widget widget = this.getRelatedWidget();
        Rectangle rectangle = widget.getBounds();
        rectangle = widget.convertLocalToScene(rectangle);
        Point point3 = arrayList.get(n2 + n);
        while (rectangle.contains(point3)) {
            arrayList.remove(n2);
            point2 = arrayList.get(n2);
            point3 = arrayList.get(n2 + n);
        }
        Anchor.Result result = this.computeBoundaryIntersectionPoint(point2, point3);
        arrayList.remove(n2);
        arrayList.add(n2, result.getAnchorSceneLocation());
        return arrayList;
    }

    @Override
    public Anchor.Result compute(Anchor.Entry entry) {
        Anchor.Result result;
        Point point = this.getRelatedSceneLocation();
        Point point2 = null;
        if (point2 == null) {
            point2 = this.getOppositeSceneLocation(entry);
        }
        if ((result = this.computeBoundaryIntersectionPoint(point, point2)) == null) {
            return (Anchor)this.new Anchor.Result(point, Anchor.DIRECTION_ANY);
        }
        return result;
    }

    private Anchor.Result computeBoundaryIntersectionPoint(Point point, Point point2) {
        float f;
        Widget widget = this.getRelatedWidget();
        Rectangle rectangle = widget.getBounds();
        if (!this.includeBorders) {
            Insets insets = widget.getBorder().getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
        if ((rectangle = widget.convertLocalToScene(rectangle)).isEmpty() || point.equals(point2)) {
            return null;
        }
        float f2 = point2.x - point.x;
        float f3 = point2.y - point.y;
        float f4 = Math.abs(f2) / (float)rectangle.width;
        Anchor.Direction direction = f4 >= (f = Math.abs(f3) / (float)rectangle.height) ? (f2 >= 0.0f ? Anchor.Direction.RIGHT : Anchor.Direction.LEFT) : (f3 >= 0.0f ? Anchor.Direction.BOTTOM : Anchor.Direction.TOP);
        float f5 = 0.5f / Math.max(f4, f);
        Point point3 = new Point(Math.round((float)point.x + f5 * f2), Math.round((float)point.y + f5 * f3));
        return (Anchor)this.new Anchor.Result(point3, direction);
    }
}

